/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.communication;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org2.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;

public class CommunicationUtilities {
    public static void writeString(DataOutputStream out, String line) throws IOException {
        byte[] byteArray = line.getBytes();
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    public static void writeStringAsBytes(DataOutputStream out, byte[] byteArray) throws IOException {
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    public static void writeBreakpoint(DataOutputStream out, Breakpoint breakpoint) throws IOException {
        out.writeShort(breakpoint.getType());
        out.writeShort(breakpoint.getLifeTime());
        if (breakpoint.getConditionalFlag()) {
            CommunicationUtilities.writeString(out, breakpoint.getExpression());
            if (!breakpoint.getStaticFlag()) {
                return;
            }
        }
        CommunicationUtilities.writeString(out, breakpoint.getFileName());
        if (breakpoint.getStaticFlag()) {
            int lineNumber = breakpoint.getLineNumber();
            out.writeInt(lineNumber);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        return new String(CommunicationUtilities.readStringAsBytes(in));
    }

    public static String readEncodedString(DataInputStream in, String encoding) throws IOException {
        byte[] byteArray = CommunicationUtilities.readStringAsBytes(in);
        String rv = CommunicationUtilities.getTextFromBytes(byteArray, encoding);
        return rv;
    }

    public static void writeEncodedString(DataOutputStream out, String line, String encoding) throws IOException {
        byte[] byteArray = CommunicationUtilities.getBytesFromText(line, encoding);
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    public static final byte[] getBytesFromText(String text, String encoding) {
        try {
            return text.getBytes(encoding);
        }
        catch (Exception exception) {
            return text.getBytes();
        }
    }

    public static final String getTextFromBytes(byte[] theBytes, String encoding) {
        try {
            return new String(theBytes, encoding);
        }
        catch (Exception exception) {
            return new String(theBytes);
        }
    }

    public static byte[] readStringAsBytes(DataInputStream in) throws IOException {
        int size = in.readInt();
        byte[] byteArray = new byte[size];
        in.readFully(byteArray);
        return byteArray;
    }

    public static Breakpoint readBreakpoint(DataInputStream in) throws IOException {
        Breakpoint breakPoint = new Breakpoint();
        breakPoint.setType(in.readShort());
        breakPoint.setLifeTime(in.readShort());
        if (breakPoint.getType() == 2) {
            breakPoint.setExpression(CommunicationUtilities.readString(in));
        }
        breakPoint.setFileName(CommunicationUtilities.readString(in));
        if (breakPoint.getType() == 1) {
            breakPoint.setLineNumber(in.readInt());
        }
        return breakPoint;
    }
}

